import lcd_bus
import fs_driver
from micropython import const
import machine
import urequests
import lcd_utils
from display_driver import init_display
import time
import json
import network
import lvgl as lv
# import math
import task_handler

# ʼWiFi
sta_if = network.WLAN(network.STA_IF)
sta_if.active(False)
SSID = "3502-2.4g"  # ΪԼwifi
PASSWORD = "25222214"  # Ϊwifi

city = "ningbo"  # Ҫʾĳ
'''
weather_dict = {'0@1x.png':'','1@1x.png':'','2@1x.png':'',
              '3@1x.png':'','4@1x.png':'','5@1x.png':'',
              '6@1x.png':'','7@1x.png':'󲿶','8@1x.png':'󲿶',
              '9@1x.png':'','10@1x.png':'','11@1x.png':'',
              '12@1x.png':'б','13@1x.png':'С','14@1x.png':'',
              '15@1x.png':'','16@1x.png':'','17@1x.png':'',
              '18@1x.png':'ش','19@1x.png':'','20@1x.png':'ѩ',
              '21@1x.png':'ѩ','22@1x.png':'Сѩ','23@1x.png':'ѩ',
              '24@1x.png':'ѩ','25@1x.png':'ѩ','26@1x.png':'',
              '27@1x.png':'ɳ','28@1x.png':'ɳ','29@1x.png':'ǿɳ',
              '30@1x.png':'','31@1x.png':'','32@1x.png':'',
              '33@1x.png':'','34@1x.png':'쫷','35@1x.png':'ȴ籩',
              '36@1x.png':'','37@1x.png':'','38@1x.png':'',
              '99@1x.png':'δ֪'}
'''
weather_url = f"https://api.seniverse.com/v3/weather/now.json?key=S9hoa4Wza9Hcs2uX_&location={city}&language=zh-Hans&unit=c"

def fetchWeather():
    try:
        result = urequests.get(weather_url)
        print(result.text)
        return result.text
    except Exception as e:
        print("Weather fetch error:", e)
        return None

def connect_wifi():
    if not sta_if.isconnected():
        print("Connecting to WiFi...")
        sta_if.active(True)
        sta_if.connect(SSID, PASSWORD)
        max_wait = 10
        while max_wait > 0:
            if sta_if.isconnected():
                print("WiFi Connected. IP:", sta_if.ifconfig()[0])
                return True
            max_wait -= 1
            time.sleep(1)
        print("WiFi Connection Failed")
        return False
    return True

# ϢֱӦı
def update_weather(e):
    if connect_wifi():
        weather_data = fetchWeather()
        if weather_data:
            try:
                weather_json = json.loads(weather_data)
                weather = weather_json["results"][0]["now"]["text"]
                temp = weather_json["results"][0]["now"]["temperature"]
                weather_image_keys = f"{weather_json["results"][0]["now"]["code"]}@1x.png"
                incity=weather_json["results"][0]["location"]["name"]
                last_update=weather_json["results"][0]["last_update"]
                
                #ui_label1.set_text(incity)                
                ui_label2.set_text(f"{temp}C")
                ui_label3.set_text(weather)
                ui_label4.set_text(last_update)
                
                try:
                    with open(f'weather_incons/{weather_image_keys}', 'rb') as f:
                        png_data = f.read()
                    img_cogwheel = lv.image_dsc_t({'data_size': len(png_data), 'data': png_data})
                    img1.set_src(img_cogwheel)
                except Exception as e:
                    print(f"Could not load weather icon {weather_image_keys}: {e}")
                    ui_label3.set_text("Icon Load Error")
            except Exception as e:
                print(f"Weather JSON parse error: {e}")
                ui_label3.set_text("Weather Parse Error")
        else:
            ui_label3.set_text("Weather Fetch Failed")
    else:
        ui_label.set_text("WiFi Not Connected")

def SetFlag( obj, flag, value):
    if (value):
        obj.add_flag(flag)
    else:
        obj.remove_flag(flag)
    return

# wifi
connect_wifi()
# ʼLVGL
lv.init()

# ʼʾ
display = init_display()
display.set_power(False)
display.init()
display.set_color_inversion(True)
display.set_rotation(lv.DISPLAY_ROTATION._0)
display.set_backlight(1)

#th = task_handler.TaskHandler()

# ʼLVGL
scr = lv.screen_active()
scr.set_style_bg_color(lv.color_hex(0x000000), 0)



# ȡ壨ǰϴesp32У
fs_drv = lv.fs_drv_t()
fs_driver.fs_register(fs_drv, 'S')
myfont = lv.binfont_create("S:myfont_18.bin")


# ȡ
weather_data = fetchWeather()
temp, weather, weather_image_keys,incity,last_update= "N/A", "Unknown", '99@1x.png',"Unknown","Unknown"
if weather_data:
    try:
        weather_json = json.loads(weather_data)
        weather = weather_json["results"][0]["now"]["text"]
        temp = weather_json["results"][0]["now"]["temperature"]
        weather_image_keys = f"{weather_json["results"][0]["now"]["code"]}@1x.png"
        print(weather)
    except Exception as e:
        print(f"Initial weather JSON parse error: {e}")

# ͼ겢ʾ
try:
    with open(f'weather_incons/{weather_image_keys}', 'rb') as f:
        png_data = f.read()
    img_cogwheel_argb = lv.image_dsc_t({
        'data_size': len(png_data),
        'data': png_data
    })
except:
    print(f"Could not find weather_incons/{weather_image_keys}")
    # Create a fallback image or handle the error appropriately
    img_cogwheel_argb = None


img1 = lv.image(scr)
if img_cogwheel_argb:
    img1.set_src(img_cogwheel_argb)
img1.align(lv.ALIGN.CENTER, 0, -25)
img1.set_size(58, 58)


# ʾУƴ
ui_label1 = lv.label(scr)
ui_label1.set_text(city.upper())
ui_label1.set_style_text_color(lv.color_hex(0x00FF00), 0)
ui_label1.align(lv.ALIGN.CENTER, 0, -80)
ui_label1.set_style_text_font(myfont, 0)

# ʾ¶
ui_label2 = lv.label(scr)
ui_label2.set_text(f"{temp}C")
ui_label2.set_style_text_color(lv.color_hex(0x00FF00), 0)
ui_label2.align(lv.ALIGN.CENTER, 0, 30)
ui_label2.set_style_text_font(myfont, 0)

# ʾ
ui_label3 = lv.label(scr)
ui_label3.set_text(weather)
ui_label3.set_style_text_color(lv.color_hex(0xFFFF00), 0)
ui_label3.align(lv.ALIGN.CENTER, 0, 10)
ui_label3.set_style_text_font(myfont, 0)

# ʾʱ
ui_label4 = lv.label(scr)
ui_label4.set_text(last_update)
ui_label4.set_style_text_color(lv.color_hex(0xFFFF00), 0)
ui_label4.align(lv.ALIGN.CENTER, 0, 100)
ui_label4.set_style_text_font(myfont, 0)

# 3Сʱһ
weather_timer = lv.timer_create(update_weather, 10800000, None)

# һϢ
update_weather(None)

        
# --- Main Loop ---
while True:
    lv.tick_inc(5)
    #lv.task_handler()
    time.sleep_ms(5)
