# display_driver.py
import lvgl as lv
import st7789
import lcd_bus
from machine import SPI, Pin
from micropython import const

_WIDTH = const(240)
_HEIGHT = const(240)

_SPI_HOST = const(1)
_SPI_SCK = const(6)
_SPI_MOSI = const(7)
_SPI_MISO = const(-1)

_LCD_FREQ = const(80000000)
_LCD_DC = const(2)
_LCD_CS = const(5)
_LCD_RST = const(4)
_LCD_BACKLIGHT = const(26)

def init_display():
    # Initialize the SPI bus
    spi_bus = SPI.Bus(
        host=_SPI_HOST,
        mosi=_SPI_MOSI,
        miso=_SPI_MISO,
        sck=_SPI_SCK
    )

    # Initialize the display bus
    display_bus = lcd_bus.SPIBus(
        spi_bus=spi_bus,
        dc=_LCD_DC,
        cs=_LCD_CS,
        freq=_LCD_FREQ
    )

    # Initialize and return the GC9A01 display driver
    return st7789.ST7789(
        data_bus=display_bus,
        display_width=_WIDTH,
        display_height=_HEIGHT,
        reset_pin=_LCD_RST,
        reset_state=st7789.STATE_LOW,
        power_on_state=st7789.STATE_HIGH,
        backlight_pin=_LCD_BACKLIGHT,
        backlight_on_state=st7789.STATE_LOW,
        offset_x=0,
        offset_y=0,
        color_space=lv.COLOR_FORMAT.RGB565,
        color_byte_order=st7789.BYTE_ORDER_BGR,
        rgb565_byte_swap=True
    )
