#ifndef JX90614_H
#define JX90614_H

#include <Arduino.h>
#include <Wire.h>

// 传感器的默认I2C地址
#define JX90614_I2C_ADDR 0x7F

// 根据说明书定义的寄存器地址
#define JX90614_REG_DATA_READY_CAL   0x02
#define JX90614_REG_DATA_READY_RAW   0x03
#define JX90614_REG_TOBJ             0x10
#define JX90614_REG_TACAL            0x16
#define JX90614_REG_TO1CAL           0x19
#define JX90614_REG_TO1RAW           0x22
#define JX90614_REG_TARAW            0x28
#define JX90614_REG_CMD              0x30

class JX90614 {
public:
  // 构造函数
  JX90614();

  // 初始化函数
  bool begin(TwoWire &wirePort = Wire);

  // 在loop中循环调用的主要数据读取函数
  bool read();

  // --- 用于获取处理后数据的函数 ---
  float getObjectTemperatureC();    // 获取摄氏度的目标物体温度
  float getAmbientTemperatureC();   // 获取摄氏度的环境温度
  double getThermopileVoltage();    // 获取校准后的热电堆电压 (单位:毫伏mV)

  // --- 用于获取原始数据的函数 ---
  long getRawObject();              // 获取原始的24位目标温度值
  long getRawAmbient();             // 获取原始的24位环境温度值 (TaCal)
  long getRawThermopileCal();       // 获取原始的24位校准后热电堆值 (To1Cal)
  long getRawAmbientADC();          // 获取原始的24位环境温度ADC值 (TaRaw)
  long getRawThermopileADC();       // 获取原始的24位热电堆ADC值 (To1Raw)

private:
  TwoWire *_wire;
  uint8_t _i2caddr;

  // --- 用于存储最新读数的变量 ---
  long rawTo;
  long rawTaCal;
  long rawTo1Cal;
  long rawTaRaw;
  long rawTo1Raw;

  // 用于从传感器读取3个字节的辅助函数
  long readThreeBytesSigned(uint8_t startRegister);
};

#endif // JX90614_H