//% color="#D32F2F" iconWidth=50 iconHeight=40 name="JX90614 红外测温"
namespace jx90614 {

    const SENSOR_OBJ_NAME = "tempSensor";

    // 注意：因为所有下拉菜单都从 JSON 文件加载，这里不再需要定义 enum 来填充选项了。

    // 辅助函数
    function _ensureBaseDeclared() {
        // 【重要】确保你的 JX90614 驱动库文件已放置在 arduinoC/libraries/ 目录下
        Generator.addInclude('Wire_H', '#include <Wire.h>');
        Generator.addInclude('JX90614_H', '#include <JX90614.h>');
        Generator.addObject(SENSOR_OBJ_NAME, 'JX90614', `${SENSOR_OBJ_NAME};`);
    }

    // --- 积木块定义 ---

    //% block="初始化 JX90614 红外测温传感器" blockType="command"
    export function init(parameter: any, block: any) {
        _ensureBaseDeclared();
        Generator.addSetup('wire_begin', 'Wire.begin();', false);
        let setupCode = `if (!${SENSOR_OBJ_NAME}.begin()) { while(1) delay(10); }`;
        Generator.addSetup(`${SENSOR_OBJ_NAME}_begin`, setupCode, true);
    }

    //% block="JX90614 传感器有新数据?" blockType="boolean"
    export function hasNewData(parameter: any, block: any) {
        _ensureBaseDeclared();
        Generator.addCode([`${SENSOR_OBJ_NAME}.read()`, Generator.ORDER_ATOMIC]);
    }

    //% block="获取 JX90614 [SOURCE] 温度 [UNIT]" blockType="reporter"
    //% SOURCE.shadow="dropdown" SOURCE.options="JX90614_SOURCES" SOURCE.defl="0" // options 指向 JSON 中的键名
    //% UNIT.shadow="dropdown" UNIT.options="JX90614_UNITS" UNIT.defl="0"      // options 指向 JSON 中的键名
    export function getTemperature(parameter: any, block: any) {
        _ensureBaseDeclared();
        // 从 JSON 获取的值是字符串 "0" 或 "1"，我们将其转为数字
        const sourceCode = parseInt(parameter.SOURCE.code);
        const unitCode = parseInt(parameter.UNIT.code);

        // 0 代表物体, 1 代表环境 (根据我们在 JSON 中的定义)
        const sourceFunc = (sourceCode === 0) ? 'getObjectTemperatureC' : 'getAmbientTemperatureC';
        
        let finalCode = `${SENSOR_OBJ_NAME}.${sourceFunc}()`;

        // 1 代表华氏度 (根据我们在 JSON 中的定义)
        if (unitCode === 1) {
            finalCode = `(${finalCode} * 1.8 + 32)`;
        }

        Generator.addCode([finalCode, Generator.ORDER_ADDITIVE]);
    }

    //% block="获取 JX90614 原始 [SOURCE] 值" blockType="reporter" subcategory="高级"
    //% SOURCE.shadow="dropdown" SOURCE.options="JX90614_SOURCES" SOURCE.defl="0" // options 指向 JSON 中的键名
    export function getRawValue(parameter: any, block: any) {
        _ensureBaseDeclared();
        const sourceCode = parseInt(parameter.SOURCE.code);
        const sourceFunc = (sourceCode === 0) ? 'getRawObject' : 'getRawAmbient';
        let finalCode = `${SENSOR_OBJ_NAME}.${sourceFunc}()`;
        Generator.addCode([finalCode, Generator.ORDER_ATOMIC]);
    }

    //% block="获取 JX90614 热电堆电压 (mV)" blockType="reporter" subcategory="高级"
    export function getThermopileVoltage(parameter: any, block: any) {
        _ensureBaseDeclared();
        let finalCode = `${SENSOR_OBJ_NAME}.getThermopileVoltage()`;
        Generator.addCode([finalCode, Generator.ORDER_ATOMIC]);
    }
}