#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE  16000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

// 如果使用 Duplex I2S 模式，请注释下面一行
#define AUDIO_I2S_METHOD_SIMPLEX

#ifdef AUDIO_I2S_METHOD_SIMPLEX

#define AUDIO_I2S_MIC_GPIO_WS   GPIO_NUM_25      //P9
#define AUDIO_I2S_MIC_GPIO_SCK  GPIO_NUM_26     //P8
#define AUDIO_I2S_MIC_GPIO_DIN  GPIO_NUM_18     //P13

#define AUDIO_I2S_SPK_GPIO_DOUT GPIO_NUM_19  //P14
#define AUDIO_I2S_SPK_GPIO_BCLK GPIO_NUM_21   //P15
#define AUDIO_I2S_SPK_GPIO_LRCK GPIO_NUM_5   //P16

#else

#define AUDIO_I2S_GPIO_WS GPIO_NUM_4
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_5
#define AUDIO_I2S_GPIO_DIN  GPIO_NUM_6
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_7

#endif

#define BOOT_BUTTON_GPIO        GPIO_NUM_0  //P5 掌控板A键
#define TOUCH_BUTTON_GPIO       GPIO_NUM_NC
#define ASR_BUTTON_GPIO         GPIO_NUM_2  //P11 掌控板B键
#define BUILTIN_LED_GPIO        GPIO_NUM_NC
//ML307 模块是4G通信
#define ML307_RX_PIN            GPIO_NUM_NC
#define ML307_TX_PIN            GPIO_NUM_NC

#define DISPLAY_SDA_PIN GPIO_NUM_23
#define DISPLAY_SCL_PIN GPIO_NUM_22
#define DISPLAY_WIDTH   128

#if CONFIG_OLED_SSD1306_128X32
#define DISPLAY_HEIGHT  32
#elif CONFIG_OLED_SSD1306_128X64
#define DISPLAY_HEIGHT  64
#else
#define DISPLAY_HEIGHT  64
#endif

#define DISPLAY_MIRROR_X true
#define DISPLAY_MIRROR_Y true


// A MCP Test: Control a lamp
#define LAMP_GPIO GPIO_NUM_20

#endif // _BOARD_CONFIG_H_
