#include "io_box_motor.h"
#include "esp_log.h"

#define MOTOR_I2C_ADDR 0x10
#define TAG "IOBoxMotor"

IOBoxMotor::IOBoxMotor(i2c_master_bus_handle_t bus_handle) {
    i2c_device_config_t dev_cfg = {
        .dev_addr_length = I2C_ADDR_BIT_LEN_7,
        .device_address = MOTOR_I2C_ADDR,
        .scl_speed_hz = 100000,
    };
    ESP_ERROR_CHECK(i2c_master_bus_add_device(bus_handle, &dev_cfg, &dev_handle_));
    ESP_LOGI(TAG, "Motor driver initialized on I2C addr 0x%02X", MOTOR_I2C_ADDR);
}

IOBoxMotor::~IOBoxMotor() {
    if (dev_handle_) {
        i2c_master_bus_rm_device(dev_handle_);
    }
}

void IOBoxMotor::runMotor(int index, int direction, int speed) {
    if (index < M1 || index > ALL) return;
    uint8_t speed_clamped = (speed > 255) ? 255 : (speed < 0 ? 0 : speed);
    uint8_t buf[3] = {0, (uint8_t)direction, speed_clamped};

    if (index == M1) {
        buf[0] = 0x00;
        i2c_master_transmit(dev_handle_, buf, 3, -1);
    } else if (index == M2) {
        buf[0] = 0x02;
        i2c_master_transmit(dev_handle_, buf, 3, -1);
    } else if (index == ALL) {
        buf[0] = 0x00;
        i2c_master_transmit(dev_handle_, buf, 3, -1);
        buf[0] = 0x02;
        i2c_master_transmit(dev_handle_, buf, 3, -1);
    }
}

void IOBoxMotor::stopMotor(int index) {
    runMotor(index, 0, 0); // 方向0，速度0
}