#ifndef IO_BOX_MOTOR_H
#define IO_BOX_MOTOR_H

#include "driver/i2c_master.h"

class IOBoxMotor {
public:
    // 构造函数：传入已初始化的I2C总线句柄
    IOBoxMotor(i2c_master_bus_handle_t bus_handle);
    ~IOBoxMotor();

    // 电机索引常量
    static const int M1 = 0;
    static const int M2 = 1;
    static const int ALL = 2;

    // 运行电机
    // direction: 0=正转, 1=反转 (需根据硬件调整)
    // speed: 0-255
    void runMotor(int index, int direction, int speed);

    // 停止电机
    void stopMotor(int index);

private:
    i2c_master_dev_handle_t dev_handle_ = nullptr;
};

#endif // IO_BOX_MOTOR_H